@extends('layouts.app')

@section('title', 'Admin - Knowledge Base')

@section('content')
<div class="admin-knowledge-base">
    <div class="container">
        <h1>Knowledge Base Management</h1>
        
        <div class="knowledge-base-form-section">
            <h2>Add New Article</h2>
            <form method="POST" action="{{ route('admin.knowledgebase.store') }}" class="knowledge-form">
                @csrf
                
                <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" id="title" name="title" required>
                </div>

                <div class="form-group">
                    <label for="category">Category</label>
                    <input type="text" id="category" name="category">
                </div>

                <div class="form-group">
                    <label for="content">Content</label>
                    <textarea id="content" name="content" rows="10" required></textarea>
                </div>

                <div class="form-group">
                    <label for="order">Order</label>
                    <input type="number" id="order" name="order" value="0">
                </div>

                <button type="submit" class="btn btn-primary">Add Article</button>
            </form>
        </div>

        <div class="knowledge-base-list-section">
            <h2>Existing Articles</h2>
            <div class="knowledge-base-list">
                @forelse($items as $item)
                    <div class="knowledge-base-item">
                        <div class="item-header">
                            <h3>{{ $item->title }}</h3>
                            <form method="POST" action="{{ route('admin.knowledgebase.delete', $item->id) }}" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </div>
                        @if($item->category)
                            <span class="category-badge">{{ $item->category }}</span>
                        @endif
                        <p>{{ Str::limit($item->content, 200) }}</p>
                    </div>
                @empty
                    <p>No articles yet.</p>
                @endforelse
            </div>
        </div>
    </div>
</div>
@endsection

